const { User } = require("../../users/user.model");
const { logger } = require("../../../core/logger/logger");

async function notifyAdminsPurchase({
	purchaseId,
	buyerUsername,
	quantity,
	totalPrice,
	totalPriceNTE,
	transactionHash,
}) {
	try {
		logger.info(`Notifying admins about ${buyerUsername}'s purchase`);

		const admins = await User.find({ role: "admin" }).select("username email");

		if (!admins || admins.length === 0) {
			logger.warn("No admin users found");
			return { success: false, message: "No admins found" };
		}

		const results = [];

		for (const admin of admins) {
			try {
				logger.info(`Notifying admin ${admin.username}`, {
						purchaseId,
						buyerUsername,
						quantity,
						totalPrice,
						totalPriceNTE,
						transactionHash,
					},
				);

				// TODO: Notification integration

				results.push({
					admin: admin.username,
					status: "logged",
					message: "Notification logged (placeholder)",
				});
			} catch (error) {
				logger.error(
					`Failed to notify ${admin.username}: ${error.message}`,
				);
				results.push({
					admin: admin.username,
					status: "failed",
					error: error.message,
				});
			}
		}

		logger.info(
			`Notified ${results.filter((r) => r.status === "logged").length}/${admins.length} admins about ${buyerUsername}'s purchase`,
		);

		return {
			success: true,
			results,
			adminsNotified: results.filter((r) => r.status === "logged").length,
			totalAdmins: admins.length,
		};
	} catch (error) {
		logger.error(
			`Failed to send admin notifications for ${buyerUsername}: ${error.message}`,
		);
		return { success: false, error: error.message };
	}
}

module.exports = {
	notifyAdminsPurchase,
};
