const mongoose = require('mongoose');

const blockchainTransactionSchema = new mongoose.Schema(
  {
    fromAddress: {
      type: String,
      required: true,
      trim: true,
    },
    hash: {
      type: String,
      required: true,
      trim: true,
    },
    network: {
      type: String,
      required: true,
      trim: true,
    },
    toAddress: {
      type: String,
      required: true,
      trim: true,
    },
    tokenContract: {
      type: String,
      required: true,
      trim: true,
    },
    traceId: {
      type: String,
      trim: true,
    },
    verifiedAt: {
      type: Date,
      required: true,
    },
  },
  { _id: false }
);

const metadataSchema = new mongoose.Schema(
  {
    creationMethod: {
      type: String,
      required: true,
      trim: true,
    },
    traceId: {
      type: String,
      required: true,
      trim: true,
    },
    deactivated_for_technical_problem: {
      type: String,
      trim: true,
    },
  },
  { _id: false }
);

const userPackageSchema = new mongoose.Schema(
  {
    userId: {
      type: mongoose.Schema.Types.ObjectId,
      required: true,
      ref: 'User',
      index: true,
    },
    username: {
      type: String,
      required: true,
      trim: true,
      index: true,
    },
    packageId: {
      type: mongoose.Schema.Types.ObjectId,
      required: true,
      ref: 'Product',
      index: true,
    },
    transactionId: {
      type: String,
      required: true,
      trim: true,
    },
    price: {
      type: Number,
      required: true,
    },
    priceNTE: {
      type: Number,
      required: true,
    },
    purchasedAt: {
      type: Date,
      required: true,
      index: true,
    },
    startDate: {
      type: Date,
      required: true,
    },
    endDate: {
      type: Date,
      required: true,
    },
    status: {
      type: String,
      required: true,
      index: true,
    },
    bonusClaimStatus: {
      type: String,
      required: true,
    },
    finalBonusClaimed: {
      type: Boolean,
      required: true,
    },
    finalBonusAmount: {
      type: Number,
    },
    finalBonusClaimedAt: {
      type: Date,
    },
    blockchainTransaction: {
      type: blockchainTransactionSchema,
      required: true,
    },
    blockchainTransactionHash: {
      type: String,
      trim: true,
    },
    deactivatedAt: {
      type: Date,
    },
    deactivationReason: {
      type: String,
      trim: true,
    },
    expiredAt: {
      type: Date,
    },
    reactivatedAt: {
      type: Date,
    },
    metadata: {
      type: metadataSchema,
    },
  },
  {
    timestamps: true,
    collection: 'userPackages',
  }
);

userPackageSchema.index({ userId: 1, status: 1 });
userPackageSchema.index({ packageId: 1, status: 1 });
userPackageSchema.index({ purchasedAt: -1 });
userPackageSchema.index({ username: 1, status: 1 });

const UserPackage = mongoose.model('UserPackage', userPackageSchema);

module.exports = UserPackage;
