const mongoose = require("mongoose");

const rankSchema = new mongoose.Schema(
	{
		name: {
			type: String,
			required: true,
			trim: true,
			unique: true,
		},
		level: {
			type: Number,
			required: true,
			unique: true,
			index: true,
		},
		requirement: {
			type: String,
			required: true,
			trim: true,
		},
		monthlySalary: {
			type: Number,
			required: true,
		},
		description: {
			type: String,
			required: true,
			trim: true,
		},
		packageName: {
			type: String,
			required: true,
			trim: true,
		},
		packageType: {
			type: String,
			required: true,
			trim: true,
		},
		isActive: {
			type: Boolean,
			required: true,
			index: true,
		},
		requirements: {
			previousRankLevel: Number,
			directPreviousRankMin: Number,
			directPreviousRankMax: mongoose.Schema.Types.Mixed,
			totalPairs: Number,
		},
		pairs: {
			type: Number,
		},
		peoplePerPair: {
			type: Number,
		},
	},
	{
		timestamps: true,
		collection: "ranks",
	},
);

const Rank = mongoose.model("Rank", rankSchema);

module.exports = { Rank };
