const express = require('express');
const { rankController } = require('./rank.controller');
const { secure } = require('../../middlewares/security.middleware');

const router = express.Router();

router.get('/',...secure('AR'), rankController.listRanks);
router.get('/active', ...secure('AR'), rankController.getActiveRanks);
router.get('/user/eligibility', ...secure('AR'), rankController.checkUserRankEligibility);
router.get('/level/:level', ...secure('AR'), rankController.getRankByLevel);
router.get('/:id', ...secure('AR'), rankController.getRankById);

// Admin only routes
router.post('/', ...secure('AR', { role: 'admin' }), rankController.createRank);
router.put('/:id', ...secure('AR', { role: 'admin' }), rankController.updateRank);
router.delete('/:id', ...secure('AR', { role: 'admin' }), rankController.deleteRank);
router.patch('/:id/status', ...secure('AR', { role: 'admin' }), rankController.toggleRankStatus);

module.exports = { rankRoutes: router };
