const mongoose = require("mongoose");

const userUpdateSchema = new mongoose.Schema(
	{
		username: {
			type: String,
			required: true,
			trim: true,
		},
		fullName: {
			type: String,
			required: false,
			trim: true,
		},
		previousRankLevel: {
			type: Number,
			required: true,
		},
		newRankLevel: {
			type: Number,
			required: true,
		},
		rankChanged: {
			type: Boolean,
			required: true,
		},
		status: {
			type: String,
			required: true,
			trim: true,
		},
		processedAt: {
			type: Date,
			required: true,
		},
		qualifiedRank: {
			type: mongoose.Schema.Types.Mixed,
		},
		errorMessage: {
			type: String,
			trim: true,
		},
	},
	{ _id: false },
);

const errorDetailSchema = new mongoose.Schema(
	{
		username: {
			type: String,
			required: true,
			trim: true,
		},
		error: {
			type: String,
			required: true,
			trim: true,
		},
		timestamp: {
			type: Date,
			required: true,
		},
	},
	{ _id: false },
);

const rankCronJobResultSchema = new mongoose.Schema(
	{
		jobType: {
			type: String,
			required: true,
			trim: true,
			index: true,
		},
		jobId: {
			type: String,
			required: true,
			trim: true,
			unique: true,
		},
		status: {
			type: String,
			required: true,
			trim: true,
			index: true,
		},
		isManual: {
			type: Boolean,
			required: true,
		},
		startTime: {
			type: Date,
			required: true,
			index: true,
		},
		endTime: {
			type: Date,
			required: true,
		},
		durationMs: {
			type: Number,
			required: true,
		},
		totalUsers: {
			type: Number,
			required: true,
		},
		usersUpdated: {
			type: Number,
			required: true,
		},
		errorCount: {
			type: Number,
			required: true,
		},
		errorDetails: {
			type: [errorDetailSchema],
			required: true,
			default: [],
		},
		userUpdates: {
			type: [userUpdateSchema],
			required: true,
			default: [],
		},
		summary: {
			type: String,
			required: true,
			trim: true,
		},
	},
	{
		timestamps: true,
		collection: "rankCronJobResults",
	},
);

rankCronJobResultSchema.index({ jobType: 1, startTime: -1 });
rankCronJobResultSchema.index({ status: 1, startTime: -1 });

const RankCronJobResult = mongoose.model(
	"RankCronJobResult",
	rankCronJobResultSchema,
);

module.exports = { RankCronJobResult };
