const express = require('express');
const { rankSalaryController } = require('./rankSalary.controller');
const { secure } = require('../../middlewares/security.middleware');

const router = express.Router();

// Check rank salary eligibility for a user
router.get('/eligibility/:username', secure('AR'), rankSalaryController.checkEligibility);

// Calculate rank salary for a user
router.get('/calculate/:username', secure('AR'), rankSalaryController.calculateSalary);

// Get all eligible users for rank salary
router.get('/eligible', secure('AR', { role: 'admin' }), rankSalaryController.getEligibleUsers);

// Check if rank salary has been distributed for a user
router.get('/distributed/:username', secure('AR'), rankSalaryController.checkDistributionStatus);

// Distribute rank salary to all eligible users
router.post('/distribute-all', secure('AR', { role: 'admin' }), rankSalaryController.distributeToAllUsers);

// Distribute rank salary to a single user
router.post('/distribute/:username', secure('AR', { role: 'admin' }), rankSalaryController.distributeToUser);

// Get detailed rank salary transactions
router.get('/transactions', secure('AR', { role: 'admin' }), rankSalaryController.getTransactions);

// Get rank salary statistics
router.get('/statistics', secure('AR', { role: 'admin' }), rankSalaryController.getStatistics);

// Update all users ranks
router.post('/update-ranks', secure('AR', { role: 'admin' }), rankSalaryController.updateAllRanks);

// Trigger manual rank update
router.post('/update-ranks/manual', secure('AR', { role: 'admin' }), rankSalaryController.triggerManualUpdate);

module.exports = { rankSalaryRoutes: router };