const mongoose = require('mongoose');

const aiFaqSchema = new mongoose.Schema(
  {
    question: {
      type: String,
      required: true,
      trim: true,
      unique: true,
      index: true,
    },
    answer: {
      type: String,
      required: true,
      trim: true,
    },
  },
  {
    timestamps: false,
    collection: 'ai-faqs',
  }
);

const AiFaq = mongoose.model('AiFaq', aiFaqSchema);

module.exports = { AiFaq };
