const mongoose = require('mongoose');

const attachmentSchema = new mongoose.Schema(
  {
    filename: {
      type: String,
      required: true,
      trim: true,
    },
    mimetype: {
      type: String,
      required: true,
      trim: true,
    },
    originalname: {
      type: String,
      required: true,
      trim: true,
    },
    path: {
      type: String,
      required: true,
      trim: true,
    },
    size: {
      type: Number,
      required: true,
    },
  },
  { _id: false }
);

const messageSchema = new mongoose.Schema(
  {
    content: {
      type: String,
      required: true,
      trim: true,
    },
    sender: {
      type: String,
      required: true,
      trim: true,
    },
    timestamp: {
      type: String,
      required: true,
      trim: true,
    },
    type: {
      type: String,
      required: true,
      trim: true,
    },
    id: {
      type: String,
      trim: true,
    },
    attachments: {
      type: [attachmentSchema],
      default: [],
    },
  },
  { _id: false }
);

const supportChatSchema = new mongoose.Schema(
  {
    userId: {
      type: String,
      required: true,
      trim: true,
      index: true,
    },
    username: {
      type: String,
      required: true,
      trim: true,
      index: true,
    },
    title: {
      type: String,
      required: true,
      trim: true,
    },
    type: {
      type: String,
      required: true,
      trim: true,
      index: true,
    },
    status: {
      type: String,
      required: true,
      trim: true,
      index: true,
    },
    priority: {
      type: String,
      required: true,
      trim: true,
      index: true,
    },
    category: {
      type: String,
      required: true,
      trim: true,
    },
    assignedAgent: {
      type: mongoose.Schema.Types.Mixed,
      required: true,
    },
    assignedAgentName: {
      type: mongoose.Schema.Types.Mixed,
      required: true,
    },
    messages: {
      type: [messageSchema],
      required: true,
      default: [],
    },
    attachments: {
      type: [attachmentSchema],
      default: [],
    },
    rating: {
      type: Number,
    },
    ratedAt: {
      type: Date,
    },
    ratedBy: {
      type: String,
      trim: true,
    },
    feedback: {
      type: mongoose.Schema.Types.Mixed,
    },
  },
  {
    timestamps: true,
    collection: 'support_chats',
  }
);

supportChatSchema.index({ userId: 1, status: 1 });
supportChatSchema.index({ username: 1, createdAt: -1 });
supportChatSchema.index({ type: 1, status: 1 });
supportChatSchema.index({ assignedAgent: 1, status: 1 });

const SupportChat = mongoose.model('SupportChat', supportChatSchema);

module.exports = { SupportChat };
