const express = require("express");
const router = express.Router();
const cronJobController = require("./cronJob.controller");
const { secure } = require("../../middlewares/security.middleware");

// All cron job routes require admin access
router.get(
	"/status",
	...secure("AR", { role: "admin" }),
	cronJobController.getStatus,
);

router.get(
	"/health",
	...secure("AR", { role: "admin" }),
	cronJobController.getHealth,
);

router.get(
	"/history",
	...secure("AR", { role: "admin" }),
	cronJobController.getHistory,
);

router.get(
	"/logs",
	...secure("AR", { role: "admin" }),
	cronJobController.getLogs,
);

router.get(
	"/stats",
	...secure("AR", { role: "admin" }),
	cronJobController.getStats,
);

router.get(
	"/analytics",
	...secure("AR", { role: "admin" }),
	cronJobController.getAnalytics,
);

router.post(
	"/restart",
	...secure("AR", { role: "admin" }),
	cronJobController.forceRestart,
);

router.get(
	"/system-info",
	...secure("AR", { role: "admin" }),
	cronJobController.getSystemInfo,
);

router.get(
	"/rank-results",
	...secure("AR", { role: "admin" }),
	cronJobController.getRankResults,
);

module.exports = cronJobRoutes = router;
