const mongoose = require('mongoose');

const cronJobLogSchema = new mongoose.Schema(
  {
    jobType: {
      type: String,
      required: true,
      trim: true,
      index: true,
    },
    jobId: {
      type: String,
      required: true,
      trim: true,
      index: true,
    },
    status: {
      type: String,
      required: true,
      trim: true,
      index: true,
    },
    isSuccess: {
      type: Boolean,
      required: true,
    },
    timestamp: {
      type: String,
      required: true,
      trim: true,
    },
    startTime: {
      type: Date,
      required: true,
      index: true,
    },
    endTime: {
      type: Date,
      required: true,
    },
    durationMs: {
      type: Number,
      required: true,
    },
    totalRetries: {
      type: Number,
      required: true,
    },
    attempts: {
      type: [
        {
          attemptNumber: {
            type: Number,
            required: true,
          },
          timestamp: {
            type: Date,
            required: true,
          },
          status: {
            type: String,
            required: true,
            trim: true,
          },
          duration: {
            type: Number,
            required: true,
          },
          result: mongoose.Schema.Types.Mixed,
          error: {
            name: String,
            message: String,
            stack: String,
          },
        },
      ],
      required: true,
    },
    finalResult: {
      type: mongoose.Schema.Types.Mixed,
      required: true,
    },
    finalError: {
      type: mongoose.Schema.Types.Mixed,
      required: true,
    },
    summary: {
      totalAttempts: {
        type: Number,
        required: true,
      },
      successfulAttempts: {
        type: Number,
        required: true,
      },
      failedAttempts: {
        type: Number,
        required: true,
      },
      avgAttemptDuration: {
        type: Number,
        required: true,
      },
    },
    systemContext: {
      platform: {
        type: String,
        required: true,
        trim: true,
      },
      nodeVersion: {
        type: String,
        required: true,
        trim: true,
      },
      environment: {
        type: String,
        required: true,
        trim: true,
      },
      memoryUsage: {
        rss: {
          type: Number,
          required: true,
        },
        heapTotal: {
          type: Number,
          required: true,
        },
        heapUsed: {
          type: Number,
          required: true,
        },
        external: {
          type: Number,
          required: true,
        },
        arrayBuffers: {
          type: Number,
          required: true,
        },
      },
    },
  },
  {
    timestamps: true,
    collection: 'cronJobLogs',
  }
);

cronJobLogSchema.index({ jobType: 1, startTime: -1 });
cronJobLogSchema.index({ status: 1, startTime: -1 });
cronJobLogSchema.index({ isSuccess: 1, jobType: 1 });

const CronJobLog = mongoose.model('CronJobLog', cronJobLogSchema);

module.exports = { CronJobLog };
