const mongoose = require('mongoose');

const databaseBackupSchema = new mongoose.Schema(
  {
    timestamp: {
      type: Date,
      required: true,
      index: true,
    },
    database: {
      type: String,
      required: true,
      trim: true,
    },
    status: {
      type: String,
      required: true,
      trim: true,
      index: true,
    },
    duration: {
      type: Number,
      required: true,
    },
    backupPath: {
      type: String,
      trim: true,
    },
    originalSize: {
      type: Number,
    },
    compressedSize: {
      type: Number,
    },
    fileCount: {
      type: Number,
    },
    error: {
      type: String,
      trim: true,
    },
  },
  {
    timestamps: true,
    collection: 'databaseBackups',
  }
);

databaseBackupSchema.index({ timestamp: -1 });
databaseBackupSchema.index({ status: 1, timestamp: -1 });
databaseBackupSchema.index({ database: 1, timestamp: -1 });

const DatabaseBackup = mongoose.model('DatabaseBackup', databaseBackupSchema);

module.exports = { DatabaseBackup };
