const mongoose = require('mongoose');

const securityLogSchema = new mongoose.Schema(
  {
    type: {
      type: String,
      required: true,
      trim: true,
      index: true,
    },
    username: {
      type: mongoose.Schema.Types.Mixed,
      required: true,
      index: true,
    },
    walletAddress: {
      type: mongoose.Schema.Types.Mixed,
      required: true,
    },
    ip: {
      type: String,
      required: true,
      trim: true,
      index: true,
    },
    userAgent: {
      type: String,
      required: true,
      trim: true,
    },
    success: {
      type: Boolean,
      required: true,
    },
    reason: {
      type: mongoose.Schema.Types.Mixed,
      required: true,
    },
    timestamp: {
      type: Date,
      required: true,
      index: true,
    },
    location: {
      type: mongoose.Schema.Types.Mixed,
      required: true,
    },
    metadata: {
      type: mongoose.Schema.Types.Mixed,
      required: true,
    },
  },
  {
    timestamps: false,
    collection: 'security_logs',
  }
);

securityLogSchema.index({ type: 1, timestamp: -1 });
securityLogSchema.index({ username: 1, type: 1 });
securityLogSchema.index({ ip: 1, timestamp: -1 });

const SecurityLog = mongoose.model('SecurityLog', securityLogSchema);

module.exports = { SecurityLog };
