const { taskService } = require('./task.service');
const { ApiResponse } = require('../../utils/ApiResponse');

const listTasks = async (req, res, next) => {
  try {
    const { status, type, limit, skip } = req.query;
    // Filter by user unless admin
    const userId = req.user.role === 'admin' ? null : req.user._id;
    const result = await taskService.list({ status, type, limit, skip, userId });
    res.json(new ApiResponse(200, result));
  } catch (err) {
    next(err);
  }
};

const getTask = async (req, res, next) => {
  try {
    const task = await taskService.getById(req.params.id);
    if (!task) {
      return res.status(404).json(new ApiResponse(404, null, 'Task not found'));
    }
    // Check ownership unless admin
    if (req.user.role !== 'admin' && task.payload?.userId !== req.user._id) {
      return res.status(403).json(new ApiResponse(403, null, 'Forbidden'));
    }
    res.json(new ApiResponse(200, task));
  } catch (err) {
    next(err);
  }
};

module.exports = { listTasks, getTask };
