const mongoose = require('mongoose');

const taskSchema = new mongoose.Schema(
  {
    type: { type: String, required: true, index: true },
    payload: { type: Object, required: true },
    status: { type: String, enum: ['QUEUED', 'RUNNING', 'COMPLETED', 'FAILED'], default: 'QUEUED', index: true },
    priority: { type: Number, default: 0 },
    attempts: { type: Number, default: 0 },
    lastError: { type: String }
  },
  { timestamps: true }
);

taskSchema.index({ status: 1, createdAt: -1 });
taskSchema.index({ type: 1, status: 1 });

const Task = mongoose.model('Task', taskSchema);

module.exports = { Task };
