const { userPackageService } = require("./userPackage.service");
const { ApiResponse } = require("../../utils/ApiResponse");

const userPackageController = {
	async getUserPackages(req, res, next) {
		try {
			const result = await userPackageService.getUserPackages(req.query);
			return res.json(
				new ApiResponse(200, result, "User packages retrieved successfully"),
			);
		} catch (error) {
			next(error);
		}
	},

	async updatePackageStatus(req, res, next) {
		try {
			const { packageId } = req.params;
			const { status } = req.body;

			const result = await userPackageService.updatePackageStatus(
				packageId,
				status,
			);
			return res.json(new ApiResponse(200, result, result.message));
		} catch (error) {
			next(error);
		}
	},

	async getPackageStats(req, res, next) {
		try {
			const result = await userPackageService.getPackageStats(req.query);
			return res.json(
				new ApiResponse(200, result, "Package stats retrieved successfully"),
			);
		} catch (error) {
			next(error);
		}
	},
};

module.exports = { userPackageController };
