const express = require("express");
const router = express.Router();
const { userPackageController } = require("./userPackage.controller");
const { secure } = require("../../middlewares/security.middleware");

// Get paginated user packages
router.get(
	"/",
	...secure("AR", { role: "admin" }),
	userPackageController.getUserPackages,
);

// Get package statistics
router.get(
	"/stats",
	...secure("AR", { role: "admin" }),
	userPackageController.getPackageStats,
);

// Update package status
router.put(
	"/:packageId/status",
	...secure("AR", { role: "admin" }),
	userPackageController.updatePackageStatus,
);

module.exports = { userPackageRoutes: router };
