const express = require("express");
const { userController } = require("./user.controller");
const { authMiddleware } = require("../../middlewares/auth.middleware");
const { secure } = require("../../middlewares/security.middleware");
const { jwtConfig } = require("../../config/jwt.config");

const router = express.Router();

// Public routes - no authentication required
router.post("/signup", userController.signup);
router.post("/login", userController.login);
router.post("/generate-token", userController.generateToken);
router.post("/verify-token", userController.verifyToken);
router.get("/check-user", userController.checkUser);

// JWT Public Key endpoint (for client-side token verification)
router.get("/public-key", (req, res) => {
	res.type("text/plain").send(jwtConfig.publicKey);
});

// Protected routes - authentication required
router.post("/logout", authMiddleware, userController.logout);
router.get("/check-login", userController.checkLogin);
router.post("/set-password", userController.setPassword);

// 2FA routes - authentication required
router.post("/2fa/generate", authMiddleware, userController.generate2FA);
router.post("/2fa/verify", authMiddleware, userController.verify2FA);
router.post("/2fa/disable", authMiddleware, userController.disable2FA);
router.post("/2fa/reset", authMiddleware, userController.reset2FA);
router.post("/2fa/test", authMiddleware, userController.test2FA);

// Token management
router.get(
	"/token-stats",
	authMiddleware,
	...secure("AR"),
	userController.getTokenStats,
);

module.exports = { authRoutes: router };
