const express = require('express');
const { userController } = require('./user.controller');
const { authMiddleware } = require('../../middlewares/auth.middleware');
const { secure } = require('../../middlewares/security.middleware');

const router = express.Router();

router.get('/', authMiddleware, ...secure('AR'), userController.listUsers);
router.get('/referral/status', authMiddleware, ...secure('AR'), userController.getReferralStats);
router.get('/network', authMiddleware, ...secure('AR'), userController.getUserNetwork);
router.get('/:id', authMiddleware, ...secure('AR'), userController.getUser);
router.get('/profile/me', authMiddleware, ...secure('AR'), userController.getUserProfile);
router.post('/:id/block', authMiddleware, ...secure('AR'), userController.blockUser);
router.post('/:id/unblock', authMiddleware, ...secure('AR'), userController.unblockUser);
router.put('/update-profile', authMiddleware, ...secure('AR'), userController.updateProfile);
router.delete('/:id/devices/:deviceId', authMiddleware, ...secure('AR'), userController.removeDevice);

module.exports = { userRoutes: router };
