const mongoose = require("mongoose");

const voteEntrySchema = new mongoose.Schema(
	{
		username: {
			type: String,
			required: true,
			trim: true,
		},
		address: {
			type: String,
			required: true,
			trim: true,
		},
		votedAt: {
			type: Date,
			required: true,
			default: Date.now,
		},
	},
	{
		_id: false,
	},
);

const voteSchema = new mongoose.Schema(
	{
		title: {
			type: String,
			required: true,
			trim: true,
			index: true,
		},
		description: {
			type: String,
			required: true,
			trim: true,
		},
		startDate: {
			type: String,
			required: true,
			index: true,
		},
		endDate: {
			type: String,
			required: true,
			index: true,
		},
		status: {
			type: String,
			required: true,
			index: true,
		},
		active: {
			type: Boolean,
			required: true,
			index: true,
		},
		icon: {
			type: String,
			required: true,
			trim: true,
		},
		votes: {
			type: [voteEntrySchema],
			required: false,
			default: [],
		},
	},
	{
		timestamps: true,
		collection: "votes",
	},
);

voteSchema.index({ status: 1, startDate: -1 });
voteSchema.index({ active: 1, status: 1 });

const Vote = mongoose.model("Vote", voteSchema);

module.exports = { Vote };
