const express = require('express');
const { voteController } = require('./vote.controller');
const { secure } = require('../../middlewares/security.middleware');

const router = express.Router();

// Admin routes
router.get('/', ...secure('AR', { role: 'admin' }), voteController.listVotes);
router.get('/:id', ...secure('AR', { role: 'admin' }), voteController.getVoteById);
router.post('/', ...secure('AR', { role: 'admin' }), voteController.createVote);
router.put('/:id', ...secure('AR', { role: 'admin' }), voteController.updateVote);
router.patch('/:id/status', ...secure('AR', { role: 'admin' }), voteController.toggleVoteStatus);
router.delete('/:id', ...secure('AR', { role: 'admin' }), voteController.deleteVote);

// Public routes - authenticated users only
router.get('/public/list', ...secure('AR'), voteController.getPublicVotes);
router.post('/:id/cast', ...secure('AR'), voteController.castVote);

module.exports = router;
