const mongoose = require("mongoose");

const balanceBreakdownSchema = new mongoose.Schema(
	{
		userId: {
			type: mongoose.Schema.Types.ObjectId,
			required: true,
			ref: "User",
			index: true,
		},
		username: {
			type: String,
			required: true,
			trim: true,
			index: true,
		},
		balances: {
			core: {
				type: Number,
				required: true,
				default: 0,
			},
			elite: {
				type: Number,
				required: true,
				default: 0,
			},
			stake: {
				type: Number,
				required: true,
				default: 0,
			},
			meta_pulse: {
				type: Number,
				required: true,
				default: 0,
			},
			others: {
				type: Number,
				required: true,
				default: 0,
			},
			total: {
				type: Number,
				required: true,
				default: 0,
			},
		},
		lastTransactionProcessed: {
			type: Date,
			required: false, 
			default: null,
			index: true, 
		},
		lastTransactionDate: {
			type: Date,
			default: null,
			index: true,
		},
		lastUpdated: {
			type: Date,
			required: true,
			default: Date.now,
			index: true,
		},
		metadata: {
			calculationType: {
				type: String,
				required: true,
				default: "automatic",
			},
			lastRecalculationReason: {
				type: String,
				required: true,
				default: "",
			},
			totalTransactionsProcessed: {
				type: Number,
				required: true,
				default: 0,
				min: 0,
			},
		},
		version: {
			type: Number,
			required: true,
			default: 1,
			min: 1,
		},
	},
	{
		timestamps: true,
		collection: "balanceBreakdown",
	},
);

const BalanceBreakdown = mongoose.model(
	"BalanceBreakdown",
	balanceBreakdownSchema,
);

module.exports = { BalanceBreakdown };
