const mongoose = require('mongoose');

const fundAdjustmentSchema = new mongoose.Schema(
  {
    userId: {
      type: mongoose.Schema.Types.ObjectId,
      required: true,
      ref: 'User',
      index: true,
    },
    username: {
      type: String,
      required: true,
      trim: true,
      index: true,
    },
    toAddress: {
      type: String,
      required: true,
      trim: true,
    },
    amountNTE: {
      type: Number,
      required: true,
    },
    amountUSD: {
      type: Number,
      required: true,
    },
    refundType: {
      type: String,
      required: true,
      trim: true,
    },
    status: {
      type: String,
      required: true,
      trim: true,
      index: true,
    },
    requestedAt: {
      type: Date,
      required: true,
    },
    processedAt: {
      type: Date,
      required: true,
    },
    confirmedAt: {
      type: Date,
      required: true,
    },
    transactionHash: {
      type: String,
      required: true,
      trim: true,
    },
    blockNumber: {
      type: Number,
      required: true,
    },
    gasUsed: {
      type: String,
      required: true,
      trim: true,
    },
    gasPrice: {
      type: String,
      required: true,
      trim: true,
    },
    metadata: {
      traceId: {
        type: String,
        required: true,
        trim: true,
      },
      walletTransactionId: {
        type: mongoose.Schema.Types.ObjectId,
        required: true,
        ref: 'WalletTransaction',
      },
      bonusTransactionId: {
        type: mongoose.Schema.Types.ObjectId,
        required: true,
        ref: 'BonusTransaction',
      },
      distributionId: {
        type: mongoose.Schema.Types.ObjectId,
        required: true,
        ref: 'BonusDistribution',
      },
      originalTransactionId: {
        type: String,
        required: true,
        trim: true,
      },
      packageName: {
        type: String,
        required: true,
        trim: true,
      },
      packageType: {
        type: String,
        required: true,
        trim: true,
      },
      fromAddress: {
        type: String,
        required: true,
        trim: true,
      },
      tokenValue: {
        type: Number,
        required: true,
      },
      walletBalanceBefore: {
        type: Number,
        required: true,
      },
      availableBalance: {
        type: Number,
        required: true,
      },
      sourceBalanceType: {
        type: String,
        required: true,
        trim: true,
      },
      isProportional: {
        type: Boolean,
        required: true,
      },
      refundTxInfo: {
        hash: {
          type: String,
          required: true,
          trim: true,
        },
        to: {
          type: String,
          required: true,
          trim: true,
        },
        amount: {
          type: String,
          required: true,
          trim: true,
        },
      },
    },
  },
  {
    timestamps: false,
    collection: 'fund_adjustments',
  }
);

fundAdjustmentSchema.index({ userId: 1, status: 1 });
fundAdjustmentSchema.index({ username: 1, requestedAt: -1 });
fundAdjustmentSchema.index({ refundType: 1, status: 1 });

const FundAdjustment = mongoose.model('FundAdjustment', fundAdjustmentSchema);

module.exports = { FundAdjustment };
