const express = require('express');
const { walletController } = require('./wallet.controller');
const { secure } = require('../../middlewares/security.middleware');
const { walletTransactionController } = require('./walletTransaction.controller');
const { walletTransactionHistoryController } = require('./walletTransactionHistory.controller');
const { adminController } = require('../admin/admin.controller');

const router = express.Router();

// Admin - wallet transaction history with search, filters, and stats
router.get('/transactions/history', ...secure('AR', { role: 'admin' }), walletTransactionHistoryController.getTransactionHistory);

// Wallet transaction routes - specific routes must come before dynamic :id route
router.get('/transactions/flagged', ...secure('AR'), adminController.getFlaggedTransactions);
router.get('/transactions', ...secure('AR'), walletTransactionController.listWalletTransactions);
router.get('/transactions/:id', ...secure('AR'), walletTransactionController.getWalletTransactionById);

router.get('/balance-breakdown', ...secure('AR'), walletController.getBalanceBreakdown);

// Balance fix routes - admin only
router.get('/balance-fix', ...secure('AR', { role: 'admin' }), walletController.fixBalances);

// Flagged transactions for refunds
router.post('/transactions/flag-refund', ...secure('AR', { role: 'admin' }), adminController.flagTransactionForRefund);
router.post('/transactions/mark-refunded', ...secure('AR'), adminController.markTransactionAsRefunded);

module.exports = { walletRoutes: router };
