const { walletTransactionService } = require("./walletTransaction.service");
const { ApiResponse } = require("../../utils/ApiResponse");
const { ApiError } = require("../../utils/ApiError");

const walletTransactionController = {
	// Get all wallet transactions filtering and pagination
	async listWalletTransactions(req, res, next) {
		try {
			const {
				username,
				type,
				subType,
				status,
				flaggedForRefund,
				refundStatus,
				startDate,
				endDate,
				minAmount,
				maxAmount,
				page = 1,
				limit = 20,
				sortBy = "createdAt",
				sortOrder = "desc",
			} = req.query;

			const options = {
				username,
				type,
				subType,
				status,
				flaggedForRefund,
				refundStatus,
				startDate,
				endDate,
				minAmount,
				maxAmount,
				page: parseInt(page),
				limit: parseInt(limit),
				sortBy,
				sortOrder,
			};

			const result = await walletTransactionService.listWalletTransactions(
				options,
			);

			res.json(
				new ApiResponse(
					200,
					result,
					"Wallet transactions retrieved successfully",
				),
			);
		} catch (err) {
			next(err);
		}
	},

	// Get a single wallet transaction by ID
	async getWalletTransactionById(req, res, next) {
		try {
			const { id } = req.params;

			const transaction =
				await walletTransactionService.getWalletTransactionById(id);

			if (!transaction) {
				throw new ApiError(404, "Wallet transaction not found");
			}

			res.json(
				new ApiResponse(
					200,
					{ transaction },
					"Wallet transaction retrieved successfully",
				),
			);
		} catch (err) {
			next(err);
		}
	},
};

module.exports = { walletTransactionController };
