const mongoose = require("mongoose");

const blockchainTransactionSchema = new mongoose.Schema(
	{
		fromAddress: {
			type: String,
			required: true,
			trim: true,
		},
		hash: {
			type: String,
			required: true,
			trim: true,
		},
		network: {
			type: String,
			required: true,
			trim: true,
		},
		paymentMethod: {
			type: String,
			required: true,
			trim: true,
		},
		toAddress: {
			type: String,
			required: true,
			trim: true,
		},
		tokenContract: {
			type: String,
			required: true,
			trim: true,
		},
	},
	{ _id: false },
);

const metadataSchema = new mongoose.Schema(
	{
		bonusTransactionId: {
			type: mongoose.Schema.Types.ObjectId,
			required: true,
		},
		distributionId: {
			type: mongoose.Schema.Types.ObjectId,
			required: true,
		},
		packageName: {
			type: String,
			required: true,
			trim: true,
		},
		packageType: {
			type: String,
			required: true,
			trim: true,
		},
		availableBalance: {
			type: Number,
		},
		baseValue: {
			type: Number,
		},
		blockchainTransaction: {
			type: blockchainTransactionSchema,
		},
		blockNumber: {
			type: Number,
		},
		bonusOrigin: {
			type: String,
			trim: true,
		},
		calculationDetails: {
			type: mongoose.Schema.Types.Mixed,
		},
		confirmedAt: {
			type: Date,
		},
		fromAddress: {
			type: String,
			trim: true,
		},
		gasPrice: {
			type: String,
			trim: true,
		},
		gasUsed: {
			type: String,
			trim: true,
		},
		generation: {
			type: Number,
		},
		isExternalPayment: {
			type: Boolean,
		},
		isProportional: {
			type: Boolean,
		},
		packageId: {
			type: String,
			trim: true,
		},
		paymentMethod: {
			type: String,
			trim: true,
		},
		percentage: {
			type: Number,
		},
		purchaseDistributionId: {
			type: String,
			trim: true,
		},
		purchaserUsername: {
			type: String,
			trim: true,
		},
		requestId: {
			type: mongoose.Schema.Types.Mixed,
		},
		sourceBalanceType: {
			type: String,
			trim: true,
		},
		toAddress: {
			type: String,
			trim: true,
		},
		tokenValue: {
			type: Number,
		},
		traceId: {
			type: String,
			trim: true,
		},
		transactionHash: {
			type: String,
			trim: true,
		},
		transactionId: {
			type: String,
			trim: true,
		},
		triggerType: {
			type: String,
			trim: true,
		},
		userPackageId: {
			type: String,
			trim: true,
		},
		walletBalanceBefore: {
			type: Number,
		},
		withdrawalId: {
			type: mongoose.Schema.Types.ObjectId,
		},
		withdrawalRequestId: {
			type: mongoose.Schema.Types.ObjectId,
		},
	},
	{ _id: false },
);

const walletTransactionSchema = new mongoose.Schema(
	{
		userId: {
			type: mongoose.Schema.Types.ObjectId,
			required: true,
			ref: "User",
			index: true,
		},
		username: {
			type: String,
			required: true,
			trim: true,
			index: true,
		},
		type: {
			type: String,
			required: true,
			index: true,
		},
		subType: {
			type: String,
			required: true,
			index: true,
		},
		amountNTE: {
			type: Number,
			required: true,
		},
		amountUSD: {
			type: Number,
			required: true,
		},
		balanceBefore: {
			type: Number,
			required: true,
		},
		balanceAfter: {
			type: Number,
			required: true,
		},
		status: {
			type: String,
			required: true,
			index: true,
		},
		description: {
			type: String,
			required: true,
			trim: true,
		},
		metadata: {
			type: metadataSchema,
			required: true,
		},
		processedAt: {
			type: Date,
			required: true,
		},
		createdAt: {
			type: Date,
			required: true,
		},
		transactionHash: {
			type: String,
			trim: true,
		},
		isExternalPayment: {
			type: Boolean,
		},
		refundStatus: {
			type: String,
			enum: ["none", "pending", "completed"],
			default: "none",
			index: true,
		},
		flaggedForRefund: {
			type: Boolean,
			default: false,
			index: true,
		},
		flagReason: {
			type: String,
			trim: true,
		},
	},
	{
		timestamps: false,
		collection: "walletTransactions",
	},
);

walletTransactionSchema.index({ userId: 1, createdAt: -1 });
walletTransactionSchema.index({ type: 1, status: 1 });
walletTransactionSchema.index({ username: 1, createdAt: -1 });
walletTransactionSchema.index({ subType: 1, status: 1 });

const WalletTransaction = mongoose.model(
	"WalletTransaction",
	walletTransactionSchema,
);

module.exports = { WalletTransaction };
