const { walletTransactionHistoryService } = require("./walletTransactionHistory.service");
const { ApiResponse } = require("../../utils/ApiResponse");

const walletTransactionHistoryController = {
	async getTransactionHistory(req, res, next) {
		try {
			const result = await walletTransactionHistoryService.getTransactionHistory(req.query);
			res.json(new ApiResponse(200, result, "Wallet transactions retrieved successfully"));
		} catch (err) {
			next(err);
		}
	},
};

module.exports = { walletTransactionHistoryController };
