const express = require("express");
const { withdrawalHistoryController } = require("./withdrawalHistory.controller");
const { withdrawalRequestHistoryController } = require("./withdrawalRequestHistory.controller");
const { secure } = require("../../middlewares/security.middleware");

const withdrawalRoutes = express.Router();

// Admin get withdrawal history with filters
withdrawalRoutes.get("/history", ...secure("AR", { role: "admin" }), withdrawalHistoryController.getWithdrawalHistory);

// Admin get withdrawal requests with filters
withdrawalRoutes.get("/requests", ...secure("AR", { role: "admin" }), withdrawalRequestHistoryController.getWithdrawalRequests);

module.exports = { withdrawalRoutes };
