const mongoose = require('mongoose');

const metadataSchema = new mongoose.Schema(
  {
    clientIP: {
      type: mongoose.Schema.Types.Mixed,
      required: true,
    },
    tokenValue: {
      type: Number,
      required: true,
    },
    userAgent: {
      type: mongoose.Schema.Types.Mixed,
      required: true,
    },
  },
  { _id: false }
);

const sourceBalanceInfoSchema = new mongoose.Schema(
  {
    availableBalance: {
      type: Number,
      required: true,
    },
    packageName: {
      type: String,
      required: true,
      trim: true,
    },
    packageType: {
      type: String,
      required: true,
      trim: true,
    },
    sourceBalanceType: {
      type: String,
      required: true,
      trim: true,
    },
    isProportional: {
      type: Boolean,
    },
  },
  { _id: false }
);

const transferResultSchema = new mongoose.Schema(
  {
    error: {
      type: String,
      required: true,
      trim: true,
    },
    message: {
      type: String,
      required: true,
      trim: true,
    },
    success: {
      type: Boolean,
      required: true,
    },
  },
  { _id: false }
);

const withdrawalRequestSchema = new mongoose.Schema(
  {
    userId: {
      type: mongoose.Schema.Types.ObjectId,
      required: true,
      ref: 'User',
      index: true,
    },
    username: {
      type: String,
      required: true,
      trim: true,
      index: true,
    },
    toAddress: {
      type: String,
      required: true,
      trim: true,
    },
    amountNTE: {
      type: Number,
      required: true,
    },
    amountUSD: {
      type: Number,
      required: true,
    },
    selectedWithdrawalType: {
      type: String,
      required: true,
      index: true,
    },
    status: {
      type: String,
      required: true,
      index: true,
    },
    traceId: {
      type: String,
      required: true,
      trim: true,
    },
    walletBalanceBefore: {
      type: Number,
      required: true,
    },
    metadata: {
      type: metadataSchema,
      required: true,
    },
    sourceBalanceInfo: {
      type: sourceBalanceInfoSchema,
      required: true,
    },
    processingStartedAt: {
      type: Date,
      required: true,
    },
    validationStartedAt: {
      type: Date,
      required: true,
    },
    transferStartedAt: {
      type: Date,
      required: true,
    },
    createdAt: {
      type: Date,
      required: true,
    },
    updatedAt: {
      type: Date,
      required: true,
    },
    blockchainBlockNumber: {
      type: Number,
    },
    blockchainCompletedAt: {
      type: Date,
    },
    blockchainTransactionHash: {
      type: String,
      trim: true,
    },
    blockchainTransferCompleted: {
      type: Boolean,
    },
    blockNumber: {
      type: Number,
    },
    claimRequestId: {
      type: String,
      trim: true,
    },
    completedAt: {
      type: Date,
    },
    failedAt: {
      type: Date,
    },
    failureReason: {
      type: String,
      trim: true,
    },
    lastStatusCheck: {
      type: Date,
    },
    loggingStartedAt: {
      type: Date,
    },
    processingVerifiedAt: {
      type: Date,
    },
    transactionHash: {
      type: String,
      trim: true,
      index: true,
    },
    transferError: {
      type: String,
      trim: true,
    },
    transferExecuted: {
      type: Boolean,
    },
    transferFailedAt: {
      type: Date,
    },
    transferInitiatedAt: {
      type: Date,
    },
    transferResult: {
      type: transferResultSchema,
    },
    idempotencyKey: {
      type: String,
      trim: true,
      unique: true,
      sparse: true,
      index: true,
    },
  },
  {
    timestamps: false,
    collection: 'withdrawalRequests',
  }
);

withdrawalRequestSchema.index({ userId: 1, status: 1 });
withdrawalRequestSchema.index({ username: 1, createdAt: -1 });
withdrawalRequestSchema.index({ status: 1, createdAt: -1 });
withdrawalRequestSchema.index({ selectedWithdrawalType: 1, status: 1 });

const WithdrawalRequest = mongoose.model('WithdrawalRequest', withdrawalRequestSchema);

module.exports = { WithdrawalRequest };
