const { withdrawalRequestHistoryService } = require("./withdrawalRequestHistory.service");
const { ApiResponse } = require("../../utils/ApiResponse");

const withdrawalRequestHistoryController = {
	async getWithdrawalRequests(req, res, next) {
		try {
			const result = await withdrawalRequestHistoryService.getWithdrawalRequests(req.query);
			res.json(new ApiResponse(200, result, "Withdrawal requests retrieved successfully"));
		} catch (err) {
			next(err);
		}
	},
};

module.exports = { withdrawalRequestHistoryController };
