// Helper function to generate email HTML from template
const generateEmailFromTemplate = (bodyContent) => {
	try {
		let template = `
<!DOCTYPE html>
<html lang="en">
	<head>
		<meta charset="UTF-8" />
		<meta name="viewport" content="width=device-width, initial-scale=1.0" />
		<title>NodeMeta</title>

		<style>
			body {
				margin: 0;
				padding: 0;
				background-color: #02040a;
				font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto,
					Arial, sans-serif;
			}

			.wrapper {
				width: 100%;
				padding: 48px 0;
			}

			.container {
				max-width: 640px;
				margin: auto;
				background: linear-gradient(180deg, #060b18, #04070f);
				border-radius: 18px;
				overflow: hidden;
				box-shadow: 0 0 0 1px rgba(0, 217, 255, 0.15),
					0 20px 60px rgba(0, 0, 0, 0.6);
			}

			.header {
				padding: 38px 26px 34px;
				text-align: center;
				background: radial-gradient(
						circle at top,
						rgba(0, 217, 255, 0.12),
						transparent 60%
					),
					linear-gradient(180deg, #070d1d, #04070f);
			}

			.logo-col {
			text-align: center;
			width: 100%;
		}

		.logo-col > * {
			display: block;
			margin: 0 auto 14px auto;
		}

		.logo-col > *:last-child {
			margin-bottom: 0;
			}

			.logo-node {
				color: #ffffff;
			}

			.logo-meta {
				color: #00e5ff;
			}

			.brand-line {
				font-size: 13px;
				letter-spacing: 0.6px;
				color: #9aa3b2;
			}

			.body {
				padding: 40px 30px;
				border-top: 1px solid rgba(0, 217, 255, 0.3);
				border-bottom: 1px solid rgba(0, 217, 255, 0.3);
			}

			.footer {
				padding: 28px 24px;
				text-align: center;
				background: linear-gradient(180deg, #03060d, #02040a);
			}

			.footer p {
				margin: 6px 0;
				font-size: 13px;
				color: #8b93a7;
			}

			.footer a {
				color: #00e5ff;
				text-decoration: none;
			}

			.footer small {
				display: block;
				font-size: 11px;
				color: #5f667a;
			}
			
			/* Responsive Design for Mobile */
			@media only screen and (max-width: 640px) {
				.wrapper {
					padding: 20px 0 !important;
				}
				
				.container {
					max-width: 100% !important;
					margin: 0 10px !important;
					border-radius: 12px !important;
				}
				
				.header {
					padding: 24px 16px !important;
				}
				
				.logo-img {
					width: 60px !important;
				}
				
				.logo-text {
					font-size: 24px !important;
				}
				
				.brand-line {
					font-size: 11px !important;
				}
				
				.body {
					padding: 24px 16px !important;
				}
				
				.footer {
					padding: 20px 16px !important;
				}
				
				/* Make tables responsive */
				table {
					font-size: 13px !important;
				}
				
				table td {
					padding: 6px 0 !important;
					word-break: break-word;
				}
				
				/* Responsive headings */
				h2 {
					font-size: 20px !important;
				}
				
				h3 {
					font-size: 16px !important;
				}
				
				/* Responsive buttons */
				a[style*="display: inline-block"] {
					display: block !important;
					margin: 10px auto !important;
					padding: 12px 20px !important;
					font-size: 14px !important;
					text-align: center !important;
				}
				
				/* Responsive boxes */
				div[style*="padding: 20px"] {
					padding: 15px !important;
				}
				
				div[style*="padding: 15px"] {
					padding: 12px !important;
				}
				
				/* Font size adjustments */
				div[style*="font-size: 18px"] {
					font-size: 16px !important;
				}
				
				/* Responsive monospace text */
				td[style*="font-family: monospace"] {
					font-size: 10px !important;
				}
			}
			
			@media only screen and (max-width: 480px) {
				.container {
					margin: 0 5px !important;
					border-radius: 8px !important;
				}
				
				.logo-img {
					width: 50px !important;
				}
				
				.logo-text {
					font-size: 20px !important;
				}
				
				.brand-line {
					font-size: 10px !important;
				}
				
				h2 {
					font-size: 18px !important;
				}
				
				table {
					font-size: 12px !important;
				}
				
				table td {
					padding: 5px 0 !important;
				}
				
				a[style*="display: inline-block"],
				a[style*="display: block"] {
					padding: 10px 16px !important;
					font-size: 13px !important;
					margin: 8px auto !important;
				}
			}
		</style>
	</head>

	<body>
		<div class="wrapper">
			<div class="container">
				<div class="header">
					<div class="logo-col">
						<img
							src="https://node-meta.com/logo/node-meta.png"
							alt="NodeMeta Logo"
							class="logo-img"
						style="width: 70px; height: auto; display: block; margin: 0 auto 14px auto; filter: drop-shadow(0 0 12px rgba(0, 217, 255, 0.5));"
					/>

					<div class="logo-text" style="font-size: 30px; font-weight: 900; letter-spacing: 2px; margin: 0 auto 14px auto; text-align: center;">
						<span class="logo-node" style="color: #ffffff;">NODE</span
						><span class="logo-meta" style="color: #00e5ff;">META</span>
					</div>

					<div class="brand-line" style="font-size: 13px; letter-spacing: 0.6px; color: #9aa3b2; text-align: center; margin: 0 auto; margin-bottom: 10px;">Decentralized Infrastructure for the Future</div>

				<div class="body"></div>

				<div class="footer">
					<div class="logo-text">
						<span class="logo-node">NODE</span
						><span class="logo-meta">META</span>
					</div>

					<p>Powering Real-World Web3 Infrastructure</p>

					<small>
						© 2026 NodeMeta. All rights reserved.<br />
						<a href="https://node-meta.com/privacy-policy">Privacy Policy</a> •
						<a href="https://node-meta.com/terms-of-service">Terms of Service</a>
					</small>
				</div>
			</div>
		</div>
	</body>
</html>`;

		// Replace the empty body div with the content
		template = template.replace(
			'<div class="body"></div>',
			`<div class="body">${bodyContent}</div>`,
		);

		return template;
	} catch (error) {
		logger.error("Failed to load email template:", error);
		// Fallback to simple HTML if template fails
		return `<!DOCTYPE html><html><body style="font-family: Arial, sans-serif; background: #0a0e1a; color: #fff; padding: 20px;">${bodyContent}</body></html>`;
	}
};
module.exports = generateEmailFromTemplate;
