const TaskStatus = {
  PENDING: 'PENDING',
  PROCESSING: 'PROCESSING',
  COMPLETED: 'COMPLETED',
  FAILED: 'FAILED',
  CANCELLED: 'CANCELLED'
};

// Centralized lock timeout configurations
const LOCK_TIMEOUTS = {
  CLAIM_PROCESSING_LOCK_MS: 10 * 60 * 1000,
  DISTRIBUTED_LOCK_MS: 5 * 60 * 1000,
  BALANCE_LOCK_MS: 2 * 60 * 1000,
  LOCK_HEARTBEAT_INTERVAL_MS: 30 * 1000,
};

// Claim queue timing configurations
const CLAIM_QUEUE_TIMING = {
  MIN_WAIT_TIME_MS: 40 * 1000,
  APPROVAL_INTERVAL_MS: 30 * 1000,
  QUEUE_CHECK_INTERVAL_MS: 10 * 1000,
  POSITION_UPDATE_INTERVAL_MS: 60 * 1000,
};

// Claim/Withdrawal limits and cooldowns
const CLAIM_LIMITS = {
  COOLDOWN_MINUTES_USER: 15,
  COOLDOWN_MINUTES_ADMIN: 5,
  MAX_CLAIMS_PER_DAY: 5,
  MAX_WITHDRAWALS_PER_DAY: 5,
  MIN_AMOUNT_NTE: 1,
  MIN_ACCOUNT_AGE_DAYS: 1,
  NEW_ACCOUNT_WARNING_DAYS: 7,
  MAX_CLAIM_AGE_HOURS: 24,
  MAX_AUTO_APPROVE_NTE: 1000,
  MAX_CLAIM_PER_TRANSACTION_USD: 1500,
};

// Time calculation constants (in milliseconds)
const TIME_CONSTANTS = {
  ONE_DAY_MS: 24 * 60 * 60 * 1000,
  ONE_HOUR_MS: 60 * 60 * 1000,
  ONE_MINUTE_MS: 60 * 1000,
};

module.exports = { 
  TaskStatus,
  LOCK_TIMEOUTS,
  CLAIM_QUEUE_TIMING,
  CLAIM_LIMITS,
  TIME_CONSTANTS,
};
