
const precisionAdd = (a, b, precision = 18) => {
  const numA = Number(a) || 0;
  const numB = Number(b) || 0;
  const result = numA + numB;
  return Number(result.toFixed(precision));
};

const precisionSubtract = (a, b, precision = 18) => {
  const numA = Number(a) || 0;
  const numB = Number(b) || 0;
  const result = numA - numB;
  return Number(result.toFixed(precision));
};

const precisionMultiply = (a, b, precision = 18) => {
  const numA = Number(a) || 0;
  const numB = Number(b) || 0;
  const result = numA * numB;
  return Number(result.toFixed(precision));
};

const precisionDivide = (a, b, precision = 18) => {
  const numA = Number(a) || 0;
  const numB = Number(b);

  if (numB === 0) {
    throw new Error('Division by zero');
  }

  const result = numA / numB;
  return Number(result.toFixed(precision));
};

const isBalanced = (a, b, tolerance = 1e-8) => {
  const numA = Number(a) || 0;
  const numB = Number(b) || 0;
  const difference = Math.abs(numA - numB);
  return difference <= tolerance;
};

const precisionRound = (num, decimals = 2) => {
  const number = Number(num) || 0;
  return Number(number.toFixed(decimals));
};

const parseWithPrecision = (str, precision = 18) => {
  const num = Number(str);
  if (isNaN(num)) {
    return 0;
  }
  return Number(num.toFixed(precision));
};

const precisionSum = (numbers, precision = 18) => {
  if (!Array.isArray(numbers)) {
    return 0;
  }

  const sum = numbers.reduce((total, num) => {
    return total + (Number(num) || 0);
  }, 0);

  return Number(sum.toFixed(precision));
};

const precisionPercentage = (part, total, precision = 2) => {
  const numPart = Number(part) || 0;
  const numTotal = Number(total) || 0;

  if (numTotal === 0) {
    return 0;
  }

  const percentage = (numPart / numTotal) * 100;
  return Number(percentage.toFixed(precision));
};

const precisionCompare = (a, b, tolerance = 1e-8) => {
  const numA = Number(a) || 0;
  const numB = Number(b) || 0;

  if (isBalanced(numA, numB, tolerance)) {
    return 0;
  }

  return numA < numB ? -1 : 1;
};

module.exports = {
  precisionAdd,
  precisionSubtract,
  precisionMultiply,
  precisionDivide,
  isBalanced,
  precisionRound,
  parseWithPrecision,
  precisionSum,
  precisionPercentage,
  precisionCompare,
};
